package conversions;
import java.awt.*;

public class MassQuantity extends ObservableQuantity {
	
	private double value;
	
	private int type=0;

	private String units = "pounds";

	private boolean metric = false;
	private String name = "";
	
	public boolean isMetric() {
		return metric;
	}
	
	public MassQuantity(
		double _value, 
		String _name,
		int _type) {
		value = _value;
		name = _name;
		type=_type;
	}
	
	public double getValue() {
		return value;
	}
	
	
	public void setValue(double d) {
		convertToEnglish();
		if (value == d) return;
		value = d;
		setChanged();
		
	}
	public int getType() {
		return type;
	}
	
	public String getUnits() {
		return units;
	}
	public void convertToMetric() {
		if (metric == true) return;
		setChanged();
		metric = true;
		units = "kg";
		value =
			value * 0.4536;
	}
	public String toString() {
		return name+"=" + value + " "+units;
	}
	public void convertToEnglish() {
		if (metric == false) return;
		setChanged();

		metric = false;
		units = "pounds";
		value =
			value /0.4536;
	}
	
	
	public  void test() {

		System.out.println(this );
		convertToEnglish();
		System.out.println(this );
		convertToMetric();
		System.out.println(this);
	}		
 
		
}